## -*-Tcl-*-
 # ###################################################################
 #  HTML mode - tools for editing HTML documents
 # 
 #  FILE: "htmlPreferences.tcl"
 #                                    created: 99-07-18 00.29.30 
 #                                last update: 01-11-03 22.42.09 
 #  Author: Johan Linde
 #  E-mail: <alpha_www_tools@go.to>
 #     www: <http://go.to/alpha_www_tools>
 #  
 # Version: 3.1.4
 # 
 # Copyright 1996-2001 by Johan Linde
 #  
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ###################################################################
 ##

#===============================================================================
# This file contains procs for settings preferences in HTML mode.
#===============================================================================

# Dialog to set HTML mode variables.
proc html::modifyFlags {{which General}} {
	global HTMLmodeVars htmlIconTxt htmlIcons htmlMenu htmlUtilsMenu mode::features global::features mode
	
	set box [eval html::${which}PrefsBox]
	set allFlags [eval html::${which}Flags]

	set attrTxt {"status bar" "dialog boxes"}
	set manTxt {"first page in manual" "table of contents without frames" "table of contents with frames"}
	set coltxt {"Simple coloring" "Complex coloring"}
	set eh 0
	if {$which == "Coloring"} {set eh 25}
	set values [eval [concat dialog -w 465 -h [expr {315 + $eh}] -b OK 385 [expr {285 + $eh}] 450 [expr {305 + $eh}] \
	  -b Cancel 300 [expr {285 +$eh}] 365 [expr {305 + $eh}] $box]]
	if {[lindex $values 1]} {return}
	if {$which == "General"} {
		set iconidx [llength $allFlags]
		if {[lindex $values [expr $iconidx + 1]] == [lindex $values [expr $iconidx + 2]]} {
			alertnote "You can't use the same menu icon for both menus. Menu icon changes are ignored."
			set allFlags [lrange $allFlags 0 [expr $iconidx - 3]]
		}
	}
	set i 1
	if {$which == "General"} {incr i}
	set haveShownColorAlert 0
	foreach flag $allFlags {
		global $flag
		incr i
		set val [lindex $values $i]
		if {$flag == "useBigWindows" || $flag == "changeInBigWindows"} {set val [lsearch -exact $attrTxt $val]}
		if {$flag == "manualStartPage"} {set val [lsearch -exact $manTxt $val]}
		if {$flag == "simpleColoring"} {set val [expr {![lsearch -exact $coltxt $val]}]}
		if {$flag == "dummyflag"} {continue}
		if {[string match "*Icon" $flag]} {set val [lindex $htmlIcons [lsearch $htmlIconTxt $val]]}
		if {$HTMLmodeVars($flag) != $val} {
			if {$which == "Word"} {
				set $flag $val
			}
			set HTMLmodeVars($flag) $val
			prefs::modifiedModeVar $flag HTML
			if {$flag == "oldStyleCommPara"} {html::SetCommentCharacters}
			if {[string match "*Color*" $flag]} {set haveShownColorAlert [html::ChangeColorizing $flag $haveShownColorAlert]}
			if {[string match "*Icon" $flag]} {
				set themenu [string trim $flag "Icon"]
				catch {removeMenu [set $themenu]}
				set $themenu $val
				menu::buildSome $themenu
				if {[info exists mode::features($mode)] && [lcontains mode::features($mode) $themenu] || \
				  [info exists global::features] && [lcontains global::features $themenu]} {insertMenu [set $themenu]}
			}
		}
	}
}

proc html::GeneralPrefsBox {} {
	global HTMLmodeVars htmlIconTxt htmlIcons alpha::colors elecStopMarker
	
	set attrTxt {"status bar" "dialog boxes"}
	set manTxt {"first page in manual" "table of contents without frames" "table of contents with frames"}

	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	set box "[dialog::title {General HTML mode Preferences} 450] \
	  -m {{Page 1 of preferences} {Page 1 of preferences} {Page 2 of preferences} {Page 3 of preferences}} 100 [expr {35 - $diff}] 300 [expr {55 - $diff}] \
	  -n {Page 1 of preferences} \
	  -c {Bring browser to front when sending a window to it} $HTMLmodeVars(browseInForeground) 10 [expr {65 - $diff}] 450 [expr {80 - $diff}] \
	  -c {Save window without asking when sending it to the browser} $HTMLmodeVars(saveWithoutAsking) 10 [expr {85 - $diff}] 450 [expr {100 - $diff}] \
	  -c {Set tags in lower case} $HTMLmodeVars(useLowerCase) 10 [expr {105 - $diff}] 450 [expr {120 - $diff}] \
	  -c {Use template stops ($elecStopMarker)} $HTMLmodeVars(useTabMarks) 10 [expr {125 - $diff}] 450 [expr {140 - $diff}] \
	  -c {Update META tags with NAME=\"DATE\" attribute when saving} $HTMLmodeVars(updateMetaDate) 10 [expr {145 - $diff}] 450 [expr {160 - $diff}] \
	  -t {Give attributes in}  10 [expr {185 - $diff}] 150 [expr {200 - $diff}]\
	  -m {[list [lindex $attrTxt $HTMLmodeVars(useBigWindows)]] {dialog boxes} {status bar}} 155 [expr {185 - $diff}] 450 [expr {205 - $diff}] \
	  -t {Change attributes in} 10 [expr {210 - $diff}] 150 [expr {225 - $diff}] \
	  -m {[list [lindex $attrTxt $HTMLmodeVars(changeInBigWindows)]] {dialog boxes} {status bar}} 155 [expr {210 - $diff}] 450 [expr {230 - $diff}] \
	  -c {Beep for first attribute (applies only if you use the status bar)} $HTMLmodeVars(promptNoisily) 10 [expr {235 - $diff}] 450 [expr {250 - $diff}] \
	  -c {Flash status bar for first attribute} $HTMLmodeVars(flashStatusBar) 10 [expr {255 - $diff}] 450 [expr {270 - $diff}] \
	  -n {Page 2 of preferences} \
	  -c {Use old style Comment Paragraph} $HTMLmodeVars(oldStyleCommPara) 10 [expr {65 - $diff}] 450 [expr {80 - $diff}]\
	  -c {Auto-indent when typing > of a tag} $HTMLmodeVars(electricGreater) 10 [expr {85 - $diff}] 450 [expr {100 - $diff}] \
	  -c {Adjust current line indentation when inserting a template} $HTMLmodeVars(adjustIndentation) 10 [expr {105 - $diff}] 450 [expr {120 - $diff}] \
	  -c {Open attribute dialog after completing an element} $HTMLmodeVars(attrDialogAfterCompleting) 10 [expr {125 - $diff}] 450 [expr {140 - $diff}] \
	  -t {'Help' opens} 10 [expr {155 - $diff}] 95 [expr {170 - $diff}] \
	  -m {[concat [list [lindex $manTxt $HTMLmodeVars(manualStartPage)]] $manTxt]} 100 [expr {155 - $diff}] 450 [expr {175 - $diff}] \
	  -c {Create missing file without asking when cmd-double-clicking a link} $HTMLmodeVars(createWithoutAsking) 10 [expr {185 - $diff}] 460 [expr {200 - $diff}] \
	  -c {Cmd-double-clicking on non-text file link opens file} $HTMLmodeVars(openNonTextFile) 10 [expr {205 - $diff}] 450 [expr {220 - $diff}] \
	  -c {Return on non-text file in home page window opens file} $HTMLmodeVars(homeOpenNonTextFile) 10 [expr {225 - $diff}] 450 [expr {240 - $diff}] \
	  -c {'Insert include tags' only inserts tags} $HTMLmodeVars(includeOnlyTags) 10 [expr {245 - $diff}] 450 [expr {260 - $diff}] \
	  -c {Preserve line endings when updating includes or moving files} $HTMLmodeVars(preserveLineEndings) 10 [expr {265 - $diff}] 450 [expr {280 - $diff}] \
	  -n {Page 3 of preferences} \
	  -t {'Last modified' text:} 10 [expr {65 - $diff}] 150 [expr {80 - $diff}] -e [list $HTMLmodeVars(lastModified)] 160 [expr {65 - $diff}] 450 [expr {80 - $diff}] \
	  -t {HTML menu icon:} 10 [expr {90 - $diff}] 170 [expr {105 - $diff}] \
	  -m [list [concat [list [lindex $htmlIconTxt [lsearch $htmlIcons $HTMLmodeVars(htmlMenuIcon)]]] $htmlIconTxt]] 180 [expr {90 - $diff}] 450 [expr {110 - $diff}] \
	  -t {HTML Utilities menu icon:} 10 [expr {115 - $diff}] 170 [expr {130 - $diff}] \
	  -m [list [concat [list [lindex $htmlIconTxt [lsearch $htmlIcons $HTMLmodeVars(htmlUtilsMenuIcon)]]] $htmlIconTxt]] 180 [expr {115 - $diff}] 450 [expr {135 - $diff}]"
	
	return $box
}

proc html::GeneralFlags {} {
	return [list browseInForeground saveWithoutAsking useLowerCase useTabMarks updateMetaDate\
	useBigWindows changeInBigWindows promptNoisily flashStatusBar oldStyleCommPara electricGreater \
	adjustIndentation attrDialogAfterCompleting manualStartPage createWithoutAsking openNonTextFile \
	homeOpenNonTextFile includeOnlyTags preserveLineEndings lastModified htmlMenuIcon htmlUtilsMenuIcon]
}

proc html::ColoringPrefsBox {} {
	global HTMLmodeVars alpha::colors
	set coltxt {"Simple coloring" "Complex coloring"}
	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	set box "[dialog::title {HTML mode Coloring Preferences} 450] \
	  -m {[concat [list [lindex $coltxt [expr {!$HTMLmodeVars(simpleColoring)}]]] $coltxt]} 100 [expr {35 - $diff}] 450 [expr {55 - $diff}] \
	  -t {Color of HTML tags:} 10 [expr {65 - $diff}] 150 [expr {80 - $diff}] \
	  -m [list [concat $HTMLmodeVars(tagColor) ${alpha::colors}]] 160 [expr {65 - $diff}] 310 [expr {85 - $diff}] \
	  -n {Complex coloring} \
	  -t {Color of attributes:} 10 [expr {90 - $diff}] 150 [expr {105 - $diff}] \
	  -m [list [concat $HTMLmodeVars(attributeColor) ${alpha::colors}]] 160 [expr {90 - $diff}] 310 [expr {110 - $diff}] \
	  -t {Color of strings:} 10 [expr {115 - $diff}] 150 [expr {130 - $diff}] \
	  -m [list [concat $HTMLmodeVars(stringColor) ${alpha::colors}]] 160 [expr {115 - $diff}] 310 [expr {135 - $diff}] \
	  -r {Always color immediately when typing} $HTMLmodeVars(ColorImmediately) 10 [expr {140 - $diff}] 300 [expr {155 - $diff}] \
	  -r {Coloring of best quality} [expr {!$HTMLmodeVars(ColorImmediately)}] 10 [expr {160 - $diff}] 300 [expr {175 - $diff}] \
	  -c {Color JavaScript keywords} $HTMLmodeVars(JavaScriptColoring) 10 [expr {185 - $diff}] 450 [expr {200 - $diff}] \
	  -t {Color of JavaScript keywords:} 10 [expr {205 - $diff}] 215 [expr {220 - $diff}] \
	  -m [list [concat $HTMLmodeVars(JavaScriptColor) ${alpha::colors}]] 220 [expr {205 - $diff}] 360 [expr {225 - $diff}] \
	  -c {Color CSS keywords} $HTMLmodeVars(CSSColoring) 10 [expr {235 - $diff}] 450 [expr {250 - $diff}] \
	  -t {Color of CSS keywords:} 10 [expr {255 - $diff}] 215 [expr {270 - $diff}] \
	  -m [list [concat $HTMLmodeVars(CSSColor) ${alpha::colors}]] 220 [expr {255 - $diff}] 360 [expr {275 - $diff}] \
	  -t {Color of JavaScript and CSS comments:} 10 [expr {285 - $diff}] 270 [expr {300 - $diff}] \
	  -m [list [concat $HTMLmodeVars(JavaCommentColor) ${alpha::colors}]] 275 [expr {285 - $diff}] 420 [expr {305 - $diff}]"

	return $box	
}

proc html::ColoringFlags {} {
	return [list simpleColoring tagColor attributeColor stringColor ColorImmediately dummyflag \
	  JavaScriptColoring JavaScriptColor CSSColoring CSSColor JavaCommentColor]
}

proc html::CheckingPrefsBox {} {
	global HTMLmodeVars
	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	set box "[dialog::title {HTML mode Checking Links Preferences} 450] \
	  -t {These settings apply when you check links with Alpha:} 10 [expr {40 - $diff}] 450 [expr {55 - $diff}] \
	  -c {Check anchors} $HTMLmodeVars(checkAnchors) 10 [expr {60 - $diff}] 450 [expr {75 - $diff}] \
	  -c {Case sensitive checking (slower)} $HTMLmodeVars(caseSensitive) 10 [expr {80 - $diff}] 450 [expr {95 - $diff}] \
	  -t {These settings apply when you check links with Big Brother:} 10 [expr {105 - $diff}] 450 [expr {120 - $diff}] \
	  -c {Bring Big Brother to front when checking links} $HTMLmodeVars(checkInFront) 10 [expr {125 - $diff}] 450 [expr {140 - $diff}] \
	  -c {Use Big Brother's link check options} $HTMLmodeVars(useBBoptions) 10 [expr {145 - $diff}] 450 [expr {160 - $diff}] \
	  -c {Ignore remote links (if you don't use Big Brother's option)} $HTMLmodeVars(ignoreRemote) 30 [expr {165 - $diff}] 450 [expr {180 - $diff}] \
	  -c {Ignore local links (if you don't use Big Brother's option)} $HTMLmodeVars(ignoreLocal) 30 [expr {185 - $diff}] 450 [expr {200 - $diff}]"
	return $box
}

proc html::CheckingFlags {} {
	return [list checkAnchors caseSensitive checkInFront useBBoptions ignoreRemote ignoreLocal]
}

proc html::WordPrefsBox {} {
	global HTMLmodeVars
	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	set box "[dialog::title {HTML mode Word Wrapping Preferences} 450] \
	  -t {Line width:} 10 [expr {40 - $diff}] 90 [expr {55 - $diff}] -e [list $HTMLmodeVars(fillColumn)] 100 [expr {40 - $diff}] 140 [expr {55 - $diff}] \
	  -t characters 145 [expr {40 - $diff}] 300 [expr {55 - $diff}] \
	  -t {The variables below determine which characters build up words, and the word wrapping. Normally\
	  there is no need to change them. Read about them in general manual if you want to change them.} \
	  10 [expr {70 - $diff}] 450 [expr {130 - $diff}] \
	  -t wordBreak: 10 [expr {140 - $diff}] 150 [expr {155 - $diff}] -e [list $HTMLmodeVars(wordBreak)] 155 [expr {140 - $diff}] 450 [expr {155 - $diff}] \
	  -t wordBreakPreface: 10 [expr {165 - $diff}] 150 [expr {180 - $diff}] -e [list $HTMLmodeVars(wordBreakPreface)] 155 [expr {165 - $diff}] 450 [expr {180 - $diff}] \
	  -t wrapBreak: 10 [expr {190 - $diff}] 150 [expr {205 - $diff}] -e [list $HTMLmodeVars(wrapBreak)] 155 [expr {190 - $diff}] 450 [expr {205 - $diff}] \
	  -t wrapBreakPreface: 10 [expr {215 - $diff}] 150 [expr {230 - $diff}] -e [list $HTMLmodeVars(wrapBreakPreface)] 155 [expr {215 - $diff}] 450 [expr {230 - $diff}]"
}

proc html::WordFlags {} {
	return [list fillColumn wordBreak wordBreakPreface wrapBreak wrapBreakPreface]
}

proc html::GlobalAttrsPrefs {} {
	global HTMLmodeVars
	set attrs " ID= CLASS= STYLE= TITLE= LANG= DIR= onClick= onDblClick= \
	 onMouseDown= onMouseUp= onMouseOver= onMouseMove= onMouseOut= onKeyPress= onKeyDown= onKeyUp="
	set alwaysask $HTMLmodeVars(alwaysaskforAttributes)
	set dontask $HTMLmodeVars(dontaskforAttributes)
	set hidden $HTMLmodeVars(neveraskforAttributes)
	html::UseAttrsDialog "HTML mode Attributes Preferences" $attrs alwaysask hidden dontask 1
	set HTMLmodeVars(alwaysaskforAttributes) $alwaysask
	set HTMLmodeVars(dontaskforAttributes) $dontask
	set HTMLmodeVars(neveraskforAttributes) $hidden
	prefs::modifiedModeVar alwaysaskforAttributes HTML
	prefs::modifiedModeVar dontaskforAttributes HTML
	prefs::modifiedModeVar neveraskforAttributes HTML
}

# Choose an item from Use Attributes menu.
proc html::UseAttributes {} {
	global html::ElemAttrOptional
	foreach a [array names html::ElemAttrOptional] {
		if {[llength [set html::ElemAttrOptional($a)]]} {lappend htmlPossibleToUse $a}
	}
	regsub " S " $htmlPossibleToUse " " htmlPossibleToUse
	if {![catch {listpick -p "Choose HTML element" [lsort $htmlPossibleToUse]} elem] &&
	$elem != ""} {html::UseAttributes2 $elem}
}

# Customize list of attributes which get asked about
proc html::UseAttributes2 {item} {
	global html::ElemAttrUsed html::ElemAttrHidden html::ElemAttrOverride
	set reqattrs [html::GetRequired $item]
	set optatts [html::GetOptional $item 1]
	set used [html::GetUsed $item $reqattrs $optatts 1]
	set hidden [html::GetHidden $item]
	set override [html::GetOverride $item]
	html::UseAttrsDialog "Attributes for $item" $optatts used hidden
	set html::ElemAttrUsed($item) $used
	set html::ElemAttrHidden($item) $hidden
	set html::ElemAttrOverride($item) $override
	prefs::modifiedArrayElement $item html::ElemAttrUsed
	prefs::modifiedArrayElement $item html::ElemAttrHidden
	prefs::modifiedArrayElement $item html::ElemAttrOverride
}

proc html::UseAttrsDialog {txt optatts us hi {do ""} {isGlobal 0}} {
	global HTMLmodeVars
	upvar $us used $hi hidden
	if {$do != ""} {upvar $do dont}
	if {!$isGlobal} {upvar override over}
	set hideExtensions $HTMLmodeVars(hideExtensions)
	set hideDeprecated $HTMLmodeVars(hideDeprecated)
	set alwaysask $HTMLmodeVars(alwaysaskforAttributes)
	set dontask $HTMLmodeVars(dontaskforAttributes)
	set neverask $HTMLmodeVars(neveraskforAttributes)
	set page 0
	set attrnumber [llength $optatts]
	set options {"Always ask about" "Don't ask about at first" "Never ask about"}
	set len 10
	if {$isGlobal} {
		set options "{Use individual settings} $options"
		set len 8
	}
	foreach a $optatts {
		if {[lcontains used $a]} {
			lappend uh $isGlobal
		} elseif {[lcontains hidden $a]} {
			lappend uh [expr {2 + $isGlobal}]
		} elseif {!$isGlobal || [lcontains dont $a]} {
			lappend uh [expr {1 + $isGlobal}]
		} else {
			lappend uh 0
		}
	}
	set start(0) 0
	set end(0) -1
	while {1} {
		set box "[dialog::title $txt 370]"
		if {!$isGlobal} {append box " -t {Global settings} 370 10 540 25"}
		if {[info tclversion] < 8.0} {
			set h 35
		} else {
			set h [expr $isGlobal ? 15 : 35]
		}
		if {$isGlobal && !$page} {
			append box " -c {Don't use extensions to HTML 4.01} $hideExtensions 10 $h 370 [expr {$h + 20}]"
			append box " -c {Don't use deprecated elements and attributes} $hideDeprecated 10 [expr {$h + 25}] 370 [expr {$h + 45}]"
			incr h 50
		}
		set n 0
		set g 0
		set g1 ""
		set end($page) [expr {$end($page) == -1 ? $start($page) + $len - 1 : $end($page)}]
		foreach a [lrange $optatts $start($page) $end($page)] {
			set m [lindex $uh [expr {$start($page) + $n}]]
			append box " -t [string trimright $a =] 10 $h 150 [expr {$h + 20}] -m {[lrange $options $m $m] $options} 160 $h 360 [expr {$h + 20}]"
			if {!$isGlobal} {
				if {[lcontains neverask $a]} {append box " -t {Never ask about} 370 $h 540 [expr {$h + 20}]"}
				if {[lcontains dontask $a]} {append box " -t {Don't ask about at first} 370 $h 540 [expr {$h + 20}]"}
				if {[lcontains alwaysask $a]} {append box " -t {Always ask about} 370 $h 540 [expr {$h + 20}]"}
				if {[lcontains alwaysask $a] || [lcontains dontask $a] || [lcontains neverask $a]} {
					incr h 20
					append box " -c {Override global setting} [lcontains over $a] 370 $h 540 [expr {$h + 20}]"
					incr h 5
					incr g
					lappend g1 1
				} else {
					lappend g1 0
				}
			} else {
				lappend g1 0
			}
			incr h 25
			incr n
			if {$h > 300} {
				set end($page) [expr {$start($page) + $n - 1}]
				break
			}
		}
		incr h 10
		set h1 [expr {$h + 20}]
		if {$page > 0} {append box " -b {<< Prev} 20 $h 85 $h1"}
		if {[expr {$start($page) + $len}] < $attrnumber} {append box " -b {Next >>} 110 $h 175 $h1"}
		set values [eval [concat dialog -w [expr {$isGlobal ? 380 : 550}] -h [expr {$h + 30}] \
		  -b OK [expr {$isGlobal ? 300 : 470}] $h [expr {$isGlobal ? 365 : 535}] $h1 \
		  -b Cancel [expr {$isGlobal ? 215 : 385}] $h [expr {$isGlobal ? 280 : 450}] $h1 $box]]
		if {$isGlobal && !$page} {
			set hideExtensions [lindex $values 2]
			set hideDeprecated [lindex $values 3]
			set values [lreplace $values 2 3]
		}
		if {[lindex $values 1]} {error "Cancel"}
		set uh1 ""
		set g2 0
		for {set i 0} {$i < $n} {incr i} {
			set v [lindex $values [expr {$i + $g2 + 2}]]
			if {[lindex $g1 $i]} {
				if {[lindex $values [expr {$i + $g2 + 3}]]} {
					lappend over [lindex $optatts [expr {$start($page) + $i}]]
					set over [lunique $over]
				} else {
					set over [lremove $over [lindex $optatts [expr {$start($page) + $i}]]]
				}
				incr g2
			}
			lappend uh1 [lsearch -exact $options $v]
		}
		set uh [eval [concat lreplace [list $uh] $start($page) $end($page) $uh1]]
		if {[lindex $values 0]} {break}
		if {$page > 0 && [lindex $values [expr {$n + $g + 2}]]} {
			incr page -1
		} else {
			incr page
			if {![info exists start($page)]} {set start($page) [expr {$end([expr {$page - 1}]) + 1}]}
			if {![info exists end($page)]} {set end($page) -1}
		}
	}
	set used ""
	set hidden ""
	set dont ""
	for {set i 0} {$i < $attrnumber} {incr i} {
		if {[lindex $uh $i] == $isGlobal} {lappend used [lindex $optatts $i]}
		if {$isGlobal && [lindex $uh $i] == 2} {lappend dont [lindex $optatts $i]}
		if {[lindex $uh $i] == [expr {2 + $isGlobal}]} {lappend hidden [lindex $optatts $i]}
	}
	foreach h {hideExtensions hideDeprecated} {
		if {[set $h] != $HTMLmodeVars($h)} {
			set HTMLmodeVars($h) [set $h]
			prefs::modifiedModeVar $h HTML
			html::Hide
		}
	}
}

proc html::IndentationPrefs {} {
	global HTMLmodeVars html::ElemLayout
	set indent $HTMLmodeVars(indentElements)
	set box [dialog::title {HTML mode Indentation Preferences} 450]
	set w0 25
	if {[info tclversion] >= 8.0} {set w0 0}
	append box " -t {Indent the content of} 10 [expr {15 + $w0}] 150 [expr {30 + $w0}]"
	set ww [expr {45 + $w0}]; set hh 10
	set elements ""
	foreach elem [lsort [array names html::ElemLayout]] {
		if {[set html::ElemLayout($elem)] == "cr2"} {
			lappend elements $elem
		}
	}
	if {[llength $elements] > 40} {
		for {set i 1} {$i <= [expr {[llength $elements]/40 + 1}]} {incr i} {
			lappend mtxt "Page $i of preferences"
		}
		append box " -m [list [concat {{Page 1 of preferences}} $mtxt]] 250 [expr {15 + $w0}] 450 [expr {35 + $w0}]"
		append box " -n {Page 1 of preferences}"
	}
	set i 1
	foreach elem $elements {
		append box " -c $elem [lcontains indent $elem] $hh $ww [expr {$hh + 100}] [expr {$ww + 15}]"
		incr ww 20
		if {$ww > [expr {225 + $w0}]} {
			set ww [expr {45 + $w0}]
			incr hh 110
			if {$hh > 440} {
				set hh 10
				append box " -n {Page [incr i] of preferences}"
			}
		}
	}
	
	if {![llength $elements]} {alertnote "No elements can be indented."; return}
	set val [eval [concat dialog -w 460 -h [expr {290 + $w0}] -b OK 380 [expr {260 + $w0}] 445 [expr {280 + $w0}] \
	  -b Cancel 295 [expr {260 + $w0}] 360 [expr {280 + $w0}] $box]]
	if {[lindex $val 1]} {return}
	set indent ""
	set ex [expr {[llength $elements] > 40}]
	for {set i 0} {$i < [llength $elements]} {incr i} {
		if {[lindex $val [expr {$i + 2 + $ex}]]} {
			lappend indent [lindex $elements $i]
		}
	}
	set HTMLmodeVars(indentElements) $indent
	prefs::modifiedModeVar indentElements HTML
}

proc html::OptionalClosingTags {} {
	global HTMLmodeVars html::OptionalClosingTags html::ElemLayout
	set box [dialog::title {HTML mode Optional Closing Tags Preferences} 450]
	set w0 25
	if {[info tclversion] >= 8.0} {set w0 0}
	append box " -t {Use the closing tags of} 10 [expr {15 + $w0}] 450 [expr {30 + $w0}]"
	set ww [expr {45 + $w0}]; set hh 10
	foreach elem ${html::OptionalClosingTags} {
		append box " -c $elem [lcontains HTMLmodeVars(optionalClosing) $elem] $hh $ww [expr {$hh + 100}] [expr {$ww + 15}]"
		incr ww 20
		if {$ww > [expr {125 + $w0}]} {
			set ww [expr {45 + $w0}]
			incr hh 110
		}
	}
	set val [eval [concat dialog -w 460 -h [expr {190 + $w0}] -b OK 380 [expr {160 + $w0}] 445 [expr {180 + $w0}] \
	  -b Cancel 295 [expr {160 + $w0}] 360 [expr {180 + $w0}] $box]]
	if {[lindex $val 1]} {return}
	set oldclosing $HTMLmodeVars(optionalClosing)
	set HTMLmodeVars(optionalClosing) ""
	for {set i 0} {$i < [llength ${html::OptionalClosingTags}]} {incr i} {
		set elem [lindex ${html::OptionalClosingTags} $i]
		if {[lindex $val [expr {$i + 2}]]} {
			lappend HTMLmodeVars(optionalClosing) $elem
		}
		if {([lindex $val [expr {$i + 2}]] && ![lcontains oldclosing $elem]) ||
		(![lindex $val [expr {$i + 2}]] && [lcontains oldclosing $elem])} {
			# Find new layout
			html::FindOptionalLayout $elem
			# Make sure content is not indented if is shouldn't be.
			if {[set html::ElemLayout($elem)] != "cr2" && [lcontains HTMLmodeVars(indentElements) $elem]} {
				set HTMLmodeVars(indentElements) [lremove $HTMLmodeVars(indentElements) $elem]
				prefs::modifiedModeVar indentElements HTML
			}
		}
	}
	prefs::modifiedModeVar optionalClosing HTML
}


proc html::ElementLayout {} {
	global html::ElemAttrOptional
	set htmlPossibleToUse [lremove -l [array names html::ElemAttrOptional] {{LI IN OL}} {{LI IN UL}}]
	regsub -all {\{INPUT TYPE=[^ ]+} $htmlPossibleToUse " " htmlPossibleToUse
	lappend htmlPossibleToUse INPUT
	if {![catch {listpick -p "Choose HTML element" [lsort $htmlPossibleToUse]} elem] &&
	$elem != ""} {html::ElementLayoutDialog $elem}
}

proc html::ElementLayoutDialog {elem} {
	global html::ElemLayout HTMLmodeVars
	switch [set html::ElemLayout($elem)] {
		nocr {set val {1 0 0 0}}
		cr0 {set val {0 1 0 0}}
		cr1 {set val {0 0 1 0}}
		cr2 {set val {0 0 0 1}}
		open00 {set val {0 0}}
		open10 {set val {1 0}}
		open01 {set val {0 1}}
		open11 {set val {1 1}}
	}
	if {[regexp {open} [set html::ElemLayout($elem)]]} {
		set layout [html::SetLayoutEmpty $val $elem]
	} else {
		set layout [html::SetLayoutClosing $val $elem]
	}
	set html::ElemLayout($elem) $layout
	prefs::modifiedArrayElement $elem html::ElemLayout
	# Make sure content is not indented if it shouldn't be.
	if {$layout != "cr2" && [lcontains HTMLmodeVars(indentElements) $elem]} {
		set HTMLmodeVars(indentElements) [lremove $HTMLmodeVars(indentElements) $elem]
		prefs::modifiedModeVar indentElements HTML
	}
}

proc html::SetLayoutEmpty {values element} {
	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	set box "[dialog::title "Layout of $element" 180] \
	-c {Always a new line before tag.} [lindex $values 0] 10 [expr {40 - $diff}] 225 [expr {55 - $diff}] \
	-c {Always a new line after tag.} [lindex $values 1] 10 [expr {60 - $diff}] 225 [expr {75 - $diff}] \
	-b OK 150 [expr {90 - $diff}] 215 [expr {110 - $diff}] -b Cancel 65 [expr {90 - $diff}] 130 [expr {110 - $diff}]"
	set values [eval [concat dialog -w 230 -h [expr {120 - $diff}] $box]]
	if {[lindex $values 3]} {error "Cancel"}
	return "open[lindex $values 0][lindex $values 1]"
}

proc html::SetLayoutClosing {values element} {
	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	set box "[dialog::title "Layout of $element" 180] \
	-r {text<TAG>text</TAG>text} [lindex $values 0] 10 [expr {40 - $diff}] 200 [expr {60 - $diff}] \
	-r {text\r<TAG>text</TAG>\rtext} [lindex $values 1] 10 [expr {70 - $diff}] 150 [expr {130 - $diff}] \
	-r {blank line\r<TAG>text</TAG>\rblank line} [lindex $values 2] 10 [expr {140 - $diff}] 150 [expr {200 - $diff}] \
	-r {blank line\r<TAG>\rtext\r</TAG>\rblank line} [lindex $values 3] 10 [expr {210 - $diff}] 150 [expr {310 - $diff}]"
	set values [eval [concat dialog -w 200 -h [expr {350 - $diff}] \
	-b OK 120 [expr {320 - $diff}] 185 [expr {340 - $diff}] -b Cancel 35 [expr {320 - $diff}] 100 [expr {340 - $diff}] $box]]
	if {[lindex $values 1]} {error "Cancel"}
	if {[lindex $values 2]} {set layout nocr}
	if {[lindex $values 3]} {set layout cr0}
	if {[lindex $values 4]} {set layout cr1}
	if {[lindex $values 5]} {set layout cr2}
	return $layout
}

proc html::TypesPrefs {type txt} {
	global HTMLmodeVars
	hook::register deactivateHook html::${type}CloseHook Text
	if {[catch {bringToFront "* $txt *"}]} { 
		new -n "* $txt *" -shell 1
		insertText [join $HTMLmodeVars($type) "\r"]
		shrinkWindow 1 
		if {$HTMLmodeVars(explainTypePrefs)} {
			set txt1 [string tolower $txt]
			set v [dialog -w 350 -h 210 -t "Modify the list of $txt1 by editing the window just opened.\
			  Each [string trim $txt1 s] must be separated by either a space or a new line.\
			  Any item containing spaces must be put within quotes."  10 10 340 75\
			  -t "The\
			  new $txt1 are saved when the window is closed.\
			  Cancel the changes by holding down the shift key while clicking the window's\
			  close box." 10 80 340 140 \
			  -c "Do not explain this to me in the future" 0 10 150 340 165 \
			  -b OK 270 180 335 200]
			if {[lindex $v 0]} {
				set HTMLmodeVars(explainTypePrefs) 0
				prefs::modifiedModeVar explainTypePrefs HTML
			}
		}
	}
}

proc html::contenttypesCloseHook {name} {
	if {$name != "* Content Types *"} {return}
	html::TypesCloseHook contenttypes
}

proc html::linktypesCloseHook {name} {
	if {$name != "* Link Types *"} {return}
	html::TypesCloseHook linktypes
}

proc html::mediatypesCloseHook {name} {
	if {$name != "* Media Descriptors *"} {return}
	html::TypesCloseHook mediatypes	
}

proc html::TypesCloseHook {type} {
	global HTMLmodeVars
	# When closing size is {0 0 0 0}
	if {[getGeometry] != {0 0 0 0}} {return}
	if {![key::shiftPressed]} {
		set HTMLmodeVars($type) [getText [minPos] [maxPos]]
		prefs::modifiedModeVar $type HTML
	}
	hook::deregister deactivateHook html::${type}CloseHook Text
}

#===============================================================================
#  Home pages  #
#===============================================================================

# Dialog to handle servers and corresponding home page folders.
proc html::HomePages {{this ""}} {
	global HTMLmodeVars html::NFmirrorFiles
	
	set pages $HTMLmodeVars(homePages)
	set servers $HTMLmodeVars(FTPservers)
	set templates $HTMLmodeVars(templateFolders)
	array set mirrors [array get html::NFmirrorFiles]
	set touchedIt 0
	if {$this == ""} {set this }
	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	while {1} {
		set box "[dialog::title {Home pages} 300] -t {URLs:} 10 [expr {40 - $diff}] 100 [expr {60 - $diff}] \
		-t {Home Page Folder:} 10 [expr {70 - $diff}] 110 [expr {100 - $diff}] \
		-t {Include Folder:} 10 [expr {110 - $diff}] 110 [expr {130 - $diff}] \
		-t {Template Folder:} 10 [expr {140 - $diff}] 120 [expr {160 - $diff}] \
		-t {Default file:} 10 [expr {170 - $diff}] 100 [expr {190 - $diff}] \
		-t {Ftp server:} 10 [expr {200 - $diff}] 100 [expr {220 - $diff}] -t {User ID:} 10 [expr {225 - $diff}] 100 [expr {245 - $diff}] \
		-t Password: 10 [expr {250 - $diff}] 100 [expr {270 - $diff}] -t Directory: 10 [expr {275 - $diff}] 100 [expr {295 - $diff}] \
		-b OK 330 [expr {325 - $diff}] 395 [expr {345 - $diff}] -b Cancel 250 [expr {325 - $diff}] 315 [expr {345 - $diff}] \
		-b New 10 [expr {325 - $diff}] 75 [expr {345 - $diff}] \
		-c {Tell Big Brother} 0 280 [expr {305 - $diff}] 400 [expr {320 - $diff}]"
		if {[llength $pages]} {
			set pgs ""
			foreach pg $pages {
				lappend pgs "[lindex $pg 1][lindex $pg 2]"
			}
			append box " -m [list [concat $this $pgs]] 125 [expr {40 - $diff}] 400 [expr {60 - $diff}]"
			append box " -b Change 85 [expr {325 - $diff}] 155 [expr {345 - $diff}] -b Remove 165 [expr {325 - $diff}] 230 [expr {345 - $diff}]"
			foreach pg $pages {
				lappend box -n "[lindex $pg 1][lindex $pg 2]" -t [dialog::specialView::file [lindex $pg 0]] 125 [expr {70 - $diff}] 400 [expr {110 - $diff}] \
				-t [lindex $pg 3] 125 [expr {170 - $diff}] 310 [expr {190 - $diff}]
				if {[llength $pg] == 5} {lappend box -t [dialog::specialView::file [lindex $pg 4]] 125 [expr {110 - $diff}] 400 [expr {130 - $diff}]}
				foreach f $servers {
					if {[lindex $f 0] == [lindex $pg 0]} {
						lappend box -t [lindex $f 1] 125 [expr {200 - $diff}] 400 [expr {220 - $diff}] \
						-t [lindex $f 2] 125 [expr {225 - $diff}] 400 [expr {245 - $diff}]
						set pwb ""
						for {set i 0} {$i < [string length [lindex $f 3]]} {incr i} {
							append pwb 
						}
						lappend box -t $pwb 125 [expr {250 - $diff}] 400 [expr {270 - $diff}] \
						-t [dialog::specialView::file [lindex $f 4]] 125 [expr {275 - $diff}] 400 [expr {295 - $diff}]
					}
				}
				foreach f $templates {
					if {[lindex $f 0] == [lindex $pg 0]} {
						lappend box -t [dialog::specialView::file [lindex $f 1]] 125 [expr {140 - $diff}] 400 [expr {160 - $diff}]
					}
				}
			}
		} else {
			append box  " -m {{None defined} {None defined}} 125 [expr {40 - $diff}] 400 [expr {60 - $diff}]"
		}
		set values [eval [concat dialog -w 410 -h [expr {355 - $diff}] $box]]
		set this [lindex $values 4]
		if {[lindex $values 0]} {
			set HTMLmodeVars(homePages) $pages
			set HTMLmodeVars(FTPservers) $servers
			set HTMLmodeVars(templateFolders) $templates
			prefs::modifiedModeVar homePages HTML
			prefs::modifiedModeVar FTPservers HTML
			prefs::modifiedModeVar templateFolders HTML
			foreach mir [array names html::NFmirrorFiles] {
				if {![info exists mirrors($mir)]} {unset html::NFmirrorFiles($mir)}
				if {![info exists mirrors($mir)] || [set html::NFmirrorFiles($mir)] != $mirrors($mir)} {
					prefs::modifiedArrayElement $mir html::NFmirrorFiles
				}
			}
			foreach mir [array names mirrors] {
				if {![info exists html::NFmirrorFiles($mir)]} {
					prefs::modifiedArrayElement $mir html::NFmirrorFiles
				}
			}
			array set html::NFmirrorFiles [array get mirrors]
			if {[lindex $values 3]} {
				if {[html::GetVersion Bbth] < 1.1} {
					alertnote "Cannot change the settings in Big Brother. You need Big Brother 1.1 or later."
				} elseif {[askyesno "Change URL mappings in Big Brother?"] == "yes"} {
					if {![app::isRunning Bbth] && [catch {app::launchBack Bbth}]} {
						alertnote "Could not find or launch Big Brother."
						return
					}
					set urlmap [html::URLmap]
					AEBuild 'Bbth' core setd "----" "obj{want:type('mapG'),from:null(),form:'prop',seld:type('mapS')}" "data" "\[$urlmap\]"
				}
			}
			return
		} elseif {[lindex $values 1]} {
			if {!$touchedIt || [askyesno "Really cancel without saving changes?"] == "yes"} {return}
		} elseif {[lindex $values 2]} {
			set newpg {{} {} {} "index.html" {}}
			set newserver {{} {} {} {}}
			set newtemplate {}
			while {1} {
				if {[catch {html::SetHomePages $pages [lindex $newpg 0] "[lindex $newpg 1][lindex $newpg 2]" [lindex $newpg 3] [lindex $newpg 4]} newpg]} {break}
				if {[html::TestHomePage $pages $newpg]} {
					lappend pages $newpg
					if {[lindex $newserver 0] != ""} {lappend servers [concat [list [lindex $newpg 0]] $newserver]}
					if {$newtemplate != ""} {lappend templates [concat [list [lindex $newpg 0]] [list $newtemplate]]}
					set this "[lindex $newpg 1][lindex $newpg 2]"
					set touchedIt 1
					break
				}
			}
		} else {
			for {set i 0} {$i < [llength $pages]} {incr i} {
				if {"[lindex [lindex $pages $i] 1][lindex [lindex $pages $i] 2]" == $this} {
					if {[lindex $values 5]} {
						set newpg [lindex $pages $i]
						set pg "[lindex $newpg 1][lindex $newpg 2]"
						set oldpage [lindex $newpg 0]
						set newserver {{} {} {} {}}
						foreach f $servers {
							if {[lindex $f 0] == $oldpage} {set newserver [lrange $f 1 end]}
						}
						set newtemplate {}
						foreach f $templates {
							if {[lindex $f 0] == $oldpage} {set newtemplate [lindex $f 1]}
						}
						while {1} {
							if {[catch {html::SetHomePages $pages [lindex $newpg 0] "[lindex $newpg 1][lindex $newpg 2]" [lindex $newpg 3] [lindex $newpg 4] $pg} newpg]} {break}
							if {[html::TestHomePage $pages $newpg $pg]} {
								set pages [lreplace $pages $i $i $newpg]
								set ns ""
								foreach f $servers {
									if {[lindex $f 0] != $oldpage} {lappend ns $f}
								}
								set servers $ns
								set nt ""
								foreach f $templates {
									if {[lindex $f 0] != $oldpage} {lappend nt $f}
								}
								set templates $nt
								if {[lindex $newserver 0] != ""} {lappend servers [concat [list [lindex $newpg 0]] $newserver]}
								if {$newtemplate != ""} {lappend templates [concat [list [lindex $newpg 0]] [list $newtemplate]]}
								if {[info exists mirrors($oldpage)]} {
									set mirrors([lindex $newpg 0]) $mirrors($oldpage)
									unset mirrors($oldpage)
								}
								set this "[lindex $newpg 1][lindex $newpg 2]"
								set touchedIt 1
								break
							}
						}
					} else {
						set tpg [lindex [lindex $pages $i] 0]
						set ns ""
						foreach f $servers {
							if {[lindex $f 0] != $tpg} {lappend ns $f}
						}
						set servers $ns
						set nt ""
						foreach f $templates {
							if {[lindex $f 0] != $tpg} {lappend nt $f}
						}
						set templates $nt
						catch {unset mirrors($tpg)}
						set pages [lreplace $pages $i $i]
						set touchedIt 1
					}
				}
			}
		}
	}
}

# Dialog to define or change a home page.
proc html::SetHomePages {pages folder url defFile inclFld {pg ""}} {
	upvar newserver server newtemplate template
	while {1} {
		set pwb ""
		for {set i 0} {$i < [string length [lindex $server 2]]} {incr i} {
			append pwb 
		}
		set box ""
		if {[info tclversion] >= 8.0} {set box "-T {Edit Home Page}"}
		lappend box -t {Home Page Folder:} 10 10 135 30 -t [dialog::specialView::file $folder] 140 10 440 50 \
		  -t {Include Folder:} 10 60 110 80 -t [dialog::specialView::file $inclFld] 130 60 440 100 \
		  -t {Template Folder:} 10 110 120 130 -t [dialog::specialView::file $template] 130 110 440 150 \
		  -t {URL:} 10 160 90 180 \
		  -e $url 100 160 440 175 -t {Default file:} 10 195 90 210 \
		-e $defFile 100 195 440 210 \
		  -t {Ftp Server:} 10 230 90 250 -e [lindex $server 0] 100 230 440 245 \
		  -t {User ID:} 10 255 90 275 -e [lindex $server 1] 100 255 440 270 \
		  -t Password: 10 280 85 300 -t $pwb 160 280 440 295 \
		  -t Directory: 10 310 90 330 -e [lindex $server 3] 100 310 440 325 \
		-b OK 370 340 435 360 -b Cancel 285 340 350 360  -b Set 90 280 150 300 \
		  -b Set 20 30 80 50 -b Set 10 80 60 100 -b Unset 70 80 120 100 \
		  -b Set 10 130 60 150 -b Unset 70 130 120 150
		set val [eval [concat dialog -w 450 -h 370 $box]]
		set url [string trim [lindex $val 0]]
		set defFile [string trim [lindex $val 1]]
		set ftp [string trim [lindex $val 2]]
		regexp {^(ftp://)?(.*)$} $ftp dum1 dum2 ftp
		set dir [string trimright [string trim [lindex $val 4]] /]
		if {[lindex $val 7] && ![catch {dialog::password "Password for $ftp:"} newpw]} {
			set pw $newpw
		} else {
			set pw [lindex $server 2]
		}
		set server [list $ftp [string trim [lindex $val 3]] \
		$pw $dir]
		if {[lindex $val 8] && ![catch {html::GetDir "Home Page Folder:"} fld]} {
			set folder $fld
		} elseif {[lindex $val 9] && ![catch {html::GetDir "Include Folder:"} fld]} {
			set inclFld $fld
		} elseif {[lindex $val 10]} {
			set inclFld ""
		} elseif {[lindex $val 11] && ![catch {html::GetDir "Template Folder:"} fld]} {
			set template $fld
		} elseif {[lindex $val 12]} {
			set template ""
		} elseif {[lindex $val 5]} {
			if {![regexp {://} $url] && $url != ""} {
				set url "http://$url"
			}
			if {[lindex $server 0] != "" && [lindex $server 1] == ""} {
				alertnote "When you specify an ftp server you must give the user ID."
			} elseif {[string length $folder] && [string length $url] && [string length $defFile]} {
				regexp -indices {://} $url css
				set sl [string first / [string range $url [expr {[lindex $css 1] + 1}] end]]
				if {$sl < 0} {
					set base "$url/"
					set path ""
				} elseif {[string index $url [expr {[string length $url] -1}]] != "/"} {
					alertnote "A directory URL ending with a slash expected."
					continue
				} else {
					set base [string range $url 0 [expr {[lindex $css 1] + $sl + 1}]]
					set path [string range $url [expr {[lindex $css 1] + $sl + 2}] end]
				}
				set ret [list $folder $base $path $defFile]
				if {$inclFld != ""} {lappend ret $inclFld}
				return  $ret
			} else {
				alertnote "Home page folder, URL, and default file must be specified."
			}
		} elseif {[lindex $val 6]} {
			error ""
		}
	}
}

proc html::TestHomePage {pages newpg {pg ""}} {
	global file::separator
	foreach p $pages {
		if {"[lindex $p 1][lindex $p 2]" == $pg} {continue}
		if {[string match "[lindex $p 1][lindex $p 2]*" "[lindex $newpg 1][lindex $newpg 2]"] ||
		[string match "[lindex $newpg 1][lindex $newpg 2]*" "[lindex $p 1][lindex $p 2]"]} {
			if {[string length "[lindex $p 1][lindex $p 2]"] > [string length "[lindex $newpg 1][lindex $newpg 2]"]} {
				set s1 "[lindex $p 1][lindex $p 2]"; set s2 "[lindex $newpg 1][lindex $newpg 2]"
			} else {
				set s2 "[lindex $p 1][lindex $p 2]"; set s1 "[lindex $newpg 1][lindex $newpg 2]"
			}
			if {$s1 == $s2} {
				alertnote "You have already defined a home page folder for $s1."
			} else {				
				dialog::alert "There is already a home page folder for [lindex $p 1][lindex $p 2].\
				  You can't define a home page folder for both [lindex $p 1][lindex $p 2] and [lindex $newpg 1][lindex $newpg 2].\
				  Instead put the content of $s1 inside $s2 and use one home page folder."
			}
			return 0
		}
	}
	set msg {"home page" "" "" "" include}
	foreach p $pages {
		foreach i {0 4} {
			if {"[lindex $p 1][lindex $p 2]" == $pg	|| [llength $p] == $i} {continue}
			foreach j {0 4} {
				if {[llength $newpg] == $j} {continue}
				if {[string match [file join [lindex $p $i] *] [file join [lindex $newpg $j] " "]] || \
				  [string match [file join [lindex $newpg $j] *] [file join [lindex $p $i] " "]]} {
					alertnote "The [lindex $msg $j] folder overlaps with the [lindex $msg $i] folder for [lindex $p 1][lindex $p 2]."
					return 0
				}
			}
		}
	}
	if {[lindex $newpg 4] != "" && 
	([string match [file join [lindex $newpg 0] *] [file join [lindex $newpg 4] " "]] ||
	[string match [file join [lindex $newpg 4] *] [file join [lindex $newpg 0] " "]])} {
		alertnote "The home page folder and include folder cannot be inside one another."
		return 0
	}
	return 1
}	


